//
//  MCLog.h
//  MCFoundation
//
//  Created by Michael Clark on 13/10/2005.
//  Copyright 2005 Marketcircle Inc. All rights reserved.
//

#import <Foundation/Foundation.h>

typedef enum _MCLogEmployees {
    MCLogEmployeeMike		= 0x1,
    MCLogEmployeeAli        = 0x2,
	MCLogEmployeeEric       = 0x4,
	MCLogEmployeeAJ         = 0x8,
	MCLogEmployeeMark       = 0x10,
	MCLogEmployeeBrent      = 0x20,
	MCLogEmployeeFraser     = 0x40,
	MCLogEmployeeKevin      = 0x80,
	MCLogEmployeeSeb        = 0x100,
	MCLogEmployeeOscar      = 0x200,
	MCLogEmployeePatrick    = 0x400,
	MCLogEmployeeThomas     = 0x800
} MCLogEmployees;

typedef enum  {
    MCLogLevelError         = 0x1,
    MCLogLevelWarn          = 0x2,
	MCLogLevelInfo          = 0x4,
	MCLogLevelVerbose       = 0x8,
	MCLogLevelDebug         = 0x10
} MCLogLevel;

extern int MCLogEnabledEmployees;

extern void MCLog(SEL selector, id object, NSString* format, ...);
extern void MCLogEnableEmployees(int employees);

#define MCErrorLog(_format_, _args_...) \
do { \
	MCLog(_cmd, self, _format_, ## _args_); \
} while (0)

#ifdef MCDEBUG

#define MCDebugLog(_format_, _args_...) \
do { \
	MCLog(_cmd, self, _format_, ## _args_); \
} while (0)

#define MCMike(_format_, _args_...) \
do { \
	if (MCLogEnabledEmployees & MCLogEmployeeMike) \
	{ \
		MCLog(_cmd, self, _format_, ## _args_); \
	} \
} while (0)

#define MCAli(_format_, _args_...) \
do { \
	if (MCLogEnabledEmployees & MCLogEmployeeAli) \
	{ \
		MCLog(_cmd, self, _format_, ## _args_); \
	} \
} while (0)

#define MCEric(_format_, _args_...) \
do { \
	if (MCLogEnabledEmployees & MCLogEmployeeEric) \
	{ \
		MCLog(_cmd, self, _format_, ## _args_); \
	} \
} while (0)

#define MCAJ(_format_, _args_...) \
do { \
	if (MCLogEnabledEmployees & MCLogEmployeeAJ) \
	{ \
		MCLog(_cmd, self, _format_, ## _args_); \
	} \
} while (0)

#define MCMark(_format_, _args_...) \
do { \
	if (MCLogEnabledEmployees & MCLogEmployeeMark) \
	{ \
		MCLog(_cmd, self, _format_, ## _args_); \
	} \
} while (0)

#define MCBrent(_format_, _args_...) \
do { \
	if (MCLogEnabledEmployees & MCLogEmployeeBrent) \
	{ \
		MCLog(_cmd, self, _format_, ## _args_); \
	} \
} while (0)

#define MCKevin(_format_, _args_...) \
do { \
	if (MCLogEnabledEmployees & MCLogEmployeeKevin) \
	{ \
		MCLog(_cmd, self, _format_, ## _args_); \
	} \
} while (0)

#define MCFraser(_format_, _args_...) \
do { \
	if (MCLogEnabledEmployees & MCLogEmployeeFraser) \
	{ \
		MCLog(_cmd, self, _format_, ## _args_); \
	} \
} while (0)

#define MCSeb(_format_, _args_...) \
do { \
	if (MCLogEnabledEmployees & MCLogEmployeeSeb) \
	{ \
		MCLog(_cmd, self, _format_, ## _args_); \
	} \
} while (0)

#define MCOscar(_format_, _args_...) \
do { \
if (MCLogEnabledEmployees & MCLogEmployeeOscar) \
{ \
MCLog(_cmd, self, _format_, ## _args_); \
} \
} while (0)

#define MCPatrick(_format_, _args_...) \
do { \
if (MCLogEnabledEmployees & MCLogEmployeeP) \
{ \
MCLog(_cmd, self, _format_, ## _args_); \
} \
} while (0)

#else

#define MCDebugLog(_format_, _args_...)
#define MCMike(_format_, _args_...)
#define MCAli(_format_, _args_...)
#define MCEric(_format_, _args_...)
#define MCAJ(_format_, _args_...)
#define MCMark(_format_, _args_...)
#define MCBrent(_format_, _args_...) 
#define MCKevin(_format_, _args_...)
#define MCFraser(_format_, _args_...)
#define MCSeb(_format_,_args_...)
#define MCOscar(_format_, _args_...)
#define MCPatrick(_format_, _args_...)

#endif /* MCDEBUG */
